/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle;

import io.github.fabricators_of_create.porting_lib.config.ConfigRegistry;
import io.github.fabricators_of_create.porting_lib.config.ConfigType;
import io.github.fabricators_of_create.porting_lib.config.ModConfigSpec;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1310;
import net.minecraft.class_156;
import net.minecraft.class_1865;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.block.entity.MantleSignBlockEntity;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.config.Config;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.data.predicate.block.BlockPropertiesPredicate;
import slimeknights.mantle.data.predicate.block.SetBlockPredicate;
import slimeknights.mantle.data.predicate.block.TagBlockPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.damage.SourceAttackerPredicate;
import slimeknights.mantle.data.predicate.damage.SourceMessagePredicate;
import slimeknights.mantle.data.predicate.entity.EntitySetPredicate;
import slimeknights.mantle.data.predicate.entity.HasEnchantmentEntityPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.data.predicate.entity.MobTypePredicate;
import slimeknights.mantle.data.predicate.entity.TagEntityPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.mantle.data.predicate.item.ItemSetPredicate;
import slimeknights.mantle.data.predicate.item.ItemTagPredicate;
import slimeknights.mantle.datagen.MantleTags;
import slimeknights.mantle.fluid.transfer.EmptyFluidContainerTransfer;
import slimeknights.mantle.fluid.transfer.EmptyFluidWithNBTTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidContainerTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidWithNBTTransfer;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.item.LecternBookItem;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.recipe.MantleRecipeSerializers;
import slimeknights.mantle.recipe.crafting.ShapedFallbackRecipe;
import slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipe;
import slimeknights.mantle.recipe.helper.TagPreference;
import slimeknights.mantle.recipe.ingredient.FluidContainerIngredient;
import slimeknights.mantle.registration.MantleRegistrations;
import slimeknights.mantle.registration.adapter.BlockEntityTypeRegistryAdapter;
import slimeknights.mantle.registration.adapter.RegistryAdapter;

public class Mantle
implements ModInitializer {
    public static final String modId = "mantle";
    public static final Logger logger = LogManager.getLogger((String)"Mantle");
    public static Mantle instance;

    public void onInitialize() {
        ConfigRegistry.registerConfig((String)modId, (ConfigType)ConfigType.CLIENT, (ModConfigSpec)Config.CLIENT_SPEC);
        ConfigRegistry.registerConfig((String)modId, (ConfigType)ConfigType.SERVER, (ModConfigSpec)Config.SERVER_SPEC);
        FluidContainerTransferManager.INSTANCE.init();
        MantleTags.init();
        instance = this;
        this.commonSetup();
        this.registerCapabilities();
        this.registerRecipeSerializers();
        this.registerBlockEntities();
        MantleLoot.registerGlobalLootModifiers();
        UseBlockCallback.EVENT.register(LecternBookItem::interactWithBlock);
    }

    private void registerCapabilities() {
    }

    private void commonSetup() {
        MantleNetwork.INSTANCE.network.initServerListener();
        MantleNetwork.registerPackets();
        MantleCommand.init();
        TagPreference.init();
    }

    private void registerRecipeSerializers() {
        RegistryAdapter adapter = new RegistryAdapter(class_7923.field_41189, modId);
        MantleRecipeSerializers.CRAFTING_SHAPED_FALLBACK = (class_1865)adapter.register(new ShapedFallbackRecipe.Serializer(), "crafting_shaped_fallback");
        MantleRecipeSerializers.CRAFTING_SHAPED_RETEXTURED = adapter.register(new ShapedRetexturedRecipe.Serializer(), "crafting_shaped_retextured");
        CustomIngredientSerializer.register((CustomIngredientSerializer)FluidContainerIngredient.SERIALIZER);
        FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(EmptyFluidContainerTransfer.ID, EmptyFluidContainerTransfer.DESERIALIZER);
        FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(FillFluidContainerTransfer.ID, FillFluidContainerTransfer.DESERIALIZER);
        FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(EmptyFluidWithNBTTransfer.ID, EmptyFluidWithNBTTransfer.DESERIALIZER);
        FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(FillFluidWithNBTTransfer.ID, FillFluidWithNBTTransfer.DESERIALIZER);
        BlockPredicate.LOADER.register(Mantle.getResource("and"), BlockPredicate.AND);
        BlockPredicate.LOADER.register(Mantle.getResource("or"), BlockPredicate.OR);
        BlockPredicate.LOADER.register(Mantle.getResource("inverted"), BlockPredicate.INVERTED);
        BlockPredicate.LOADER.register(Mantle.getResource("any"), BlockPredicate.ANY.getLoader());
        BlockPredicate.LOADER.register(Mantle.getResource("requires_tool"), BlockPredicate.REQUIRES_TOOL.getLoader());
        BlockPredicate.LOADER.register(Mantle.getResource("set"), SetBlockPredicate.LOADER);
        BlockPredicate.LOADER.register(Mantle.getResource("tag"), TagBlockPredicate.LOADER);
        BlockPredicate.LOADER.register(Mantle.getResource("block_properties"), BlockPropertiesPredicate.LOADER);
        ItemPredicate.LOADER.register(Mantle.getResource("and"), ItemPredicate.AND);
        ItemPredicate.LOADER.register(Mantle.getResource("or"), ItemPredicate.OR);
        ItemPredicate.LOADER.register(Mantle.getResource("inverted"), ItemPredicate.INVERTED);
        ItemPredicate.LOADER.register(Mantle.getResource("any"), ItemPredicate.ANY.getLoader());
        ItemPredicate.LOADER.register(Mantle.getResource("set"), ItemSetPredicate.LOADER);
        ItemPredicate.LOADER.register(Mantle.getResource("tag"), ItemTagPredicate.LOADER);
        LivingEntityPredicate.LOADER.register(Mantle.getResource("and"), LivingEntityPredicate.AND);
        LivingEntityPredicate.LOADER.register(Mantle.getResource("or"), LivingEntityPredicate.OR);
        LivingEntityPredicate.LOADER.register(Mantle.getResource("inverted"), LivingEntityPredicate.INVERTED);
        LivingEntityPredicate.LOADER.register(Mantle.getResource("any"), LivingEntityPredicate.ANY.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("fire_immune"), LivingEntityPredicate.FIRE_IMMUNE.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("water_sensitive"), LivingEntityPredicate.WATER_SENSITIVE.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("on_fire"), LivingEntityPredicate.ON_FIRE.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("on_ground"), LivingEntityPredicate.ON_GROUND.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("crouching"), LivingEntityPredicate.CROUCHING.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("eyes_in_water"), LivingEntityPredicate.EYES_IN_WATER.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("feet_in_water"), LivingEntityPredicate.FEET_IN_WATER.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("underwater"), LivingEntityPredicate.UNDERWATER.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("raining_at"), LivingEntityPredicate.RAINING.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("set"), EntitySetPredicate.LOADER);
        LivingEntityPredicate.LOADER.register(Mantle.getResource("tag"), TagEntityPredicate.LOADER);
        LivingEntityPredicate.LOADER.register(Mantle.getResource("mob_type"), MobTypePredicate.LOADER);
        LivingEntityPredicate.LOADER.register(Mantle.getResource("has_enchantment"), HasEnchantmentEntityPredicate.LOADER);
        MobTypePredicate.MOB_TYPES.register(new class_2960("undefined"), class_1310.field_6290);
        MobTypePredicate.MOB_TYPES.register(new class_2960("undead"), class_1310.field_6289);
        MobTypePredicate.MOB_TYPES.register(new class_2960("arthropod"), class_1310.field_6293);
        MobTypePredicate.MOB_TYPES.register(new class_2960("illager"), class_1310.field_6291);
        MobTypePredicate.MOB_TYPES.register(new class_2960("water"), class_1310.field_6292);
        DamageSourcePredicate.LOADER.register(Mantle.getResource("and"), DamageSourcePredicate.AND);
        DamageSourcePredicate.LOADER.register(Mantle.getResource("or"), DamageSourcePredicate.OR);
        DamageSourcePredicate.LOADER.register(Mantle.getResource("inverted"), DamageSourcePredicate.INVERTED);
        DamageSourcePredicate.LOADER.register(Mantle.getResource("any"), DamageSourcePredicate.ANY.getLoader());
        DamageSourcePredicate.LOADER.register(Mantle.getResource("projectile"), DamageSourcePredicate.PROJECTILE.getLoader());
        DamageSourcePredicate.LOADER.register(Mantle.getResource("explosion"), DamageSourcePredicate.EXPLOSION.getLoader());
        DamageSourcePredicate.LOADER.register(Mantle.getResource("bypass_armor"), DamageSourcePredicate.BYPASS_ARMOR.getLoader());
        DamageSourcePredicate.LOADER.register(Mantle.getResource("damage_helmet"), DamageSourcePredicate.DAMAGE_HELMET.getLoader());
        DamageSourcePredicate.LOADER.register(Mantle.getResource("bypass_invulnerable"), DamageSourcePredicate.BYPASS_INVULNERABLE.getLoader());
        DamageSourcePredicate.LOADER.register(Mantle.getResource("bypass_magic"), DamageSourcePredicate.BYPASS_MAGIC.getLoader());
        DamageSourcePredicate.LOADER.register(Mantle.getResource("fire"), DamageSourcePredicate.FIRE.getLoader());
        DamageSourcePredicate.LOADER.register(Mantle.getResource("magic"), DamageSourcePredicate.MAGIC.getLoader());
        DamageSourcePredicate.LOADER.register(Mantle.getResource("fall"), DamageSourcePredicate.FALL.getLoader());
        DamageSourcePredicate.LOADER.register(Mantle.getResource("can_protect"), DamageSourcePredicate.CAN_PROTECT.getLoader());
        DamageSourcePredicate.LOADER.register(Mantle.getResource("melee"), DamageSourcePredicate.MELEE.getLoader());
        DamageSourcePredicate.LOADER.register(Mantle.getResource("message"), SourceMessagePredicate.LOADER);
        DamageSourcePredicate.LOADER.register(Mantle.getResource("attacker"), SourceAttackerPredicate.LOADER);
    }

    private void registerBlockEntities() {
        BlockEntityTypeRegistryAdapter adapter = new BlockEntityTypeRegistryAdapter();
        MantleRegistrations.SIGN = adapter.register(MantleSignBlockEntity::new, "sign", MantleSignBlockEntity::buildSignBlocks);
    }

    public static class_2960 getResource(String name) {
        return new class_2960(modId, name);
    }

    public static String makeDescriptionId(String base, String name) {
        return class_156.method_646((String)base, (class_2960)Mantle.getResource(name));
    }

    public static class_5250 makeComponent(String base, String name) {
        return class_2561.method_43471((String)Mantle.makeDescriptionId(base, name));
    }
}

